# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3)
    if current_round == 1:
        return "C"
    elif current_round <= 3:
        return "D"
    
    # Middle Rounds (4-7)
    elif current_round <= 7:
        if len(opp_history) >= 2 and opp_history[1] == "C" and opp_history[2] == "C":
            return "D"
        else:
            return "D" if not opp_history else opp_history[-1]
    
    # Final Rounds (8-10)
    else:
        if not opp_history:
            return "D"
        # Tit-for-Tat (TFT)
        return opp_history[-1]